/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.apace100.origins.power.PowerType;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class GainedPowerCriterion
extends AbstractCriterionTrigger<Conditions> {
    public static GainedPowerCriterion INSTANCE = new GainedPowerCriterion();
    private static final ResourceLocation ID = new ResourceLocation("origins", "gained_power");

    protected Conditions conditionsFromJson(JsonObject obj, EntityPredicate.AndPredicate playerPredicate, ConditionArrayParser predicateDeserializer) {
        ResourceLocation id = ResourceLocation.func_208304_a((String)JSONUtils.func_151200_h((JsonObject)obj, (String)"power"));
        return new Conditions(playerPredicate, id);
    }

    public void trigger(ServerPlayerEntity player, PowerType<?> type) {
        this.func_235959_a_(player, conditions -> conditions.matches(type));
    }

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public static class Conditions
    extends CriterionInstance {
        private final ResourceLocation powerId;

        public Conditions(EntityPredicate.AndPredicate player, ResourceLocation powerId) {
            super(ID, player);
            this.powerId = powerId;
        }

        public boolean matches(PowerType<?> powerType) {
            return powerType.getIdentifier().equals((Object)this.powerId);
        }

        public JsonObject func_230240_a_(ConditionArraySerializer predicateSerializer) {
            JsonObject jsonObject = super.func_230240_a_(predicateSerializer);
            jsonObject.add("power", (JsonElement)new JsonPrimitive(this.powerId.toString()));
            return jsonObject;
        }
    }
}

